<?php
/**
 * Lists out all the options from the Layouts Section of the theme options
 * This file is included in functions.php
 *
 * @package Suffusion
 * @subpackage Admin
 */

global $suffusion_404_title, $suffusion_404_content, $suffusion_all_sitemap_entities, $suffusion_sitemap_entities;
$suffusion_layouts_options = array(
	array("name" => "Layouts",
		"type" => "sub-section-2",
		"category" => "layouts",
		"parent" => "root"
	),

	array("name" => "Default Sidebar Layout",
		"type" => "sub-section-3",
		"category" => "default",
		"parent" => "layouts"
	),

	array("name" => "The \"Default\" Sidebar layout",
		"desc" => "This layout is assigned to every post / page / view on your site, unless specifically overridden.
			Here you should pick the layout that you will use most frequently. E.g. If you want 2 sidebars across your site, pick 2 sidebars below.
			You can then position the sidebars left or right by going to <em>Sidebars &rarr; Sidebar 1</em> or <em>Sidebars &rarr; Sidebar 2</em>.",
		"parent" => "default",
		"type" => "blurb"
	),

	array("name" => "Sidebars",
		"category" => "sidebars",
		"parent" => "default",
		"type" => "sub-section-4",),

	array("name" => "How many sidebars?",
		"desc" => "The theme is set up with one sidebar (a two-column theme) by default. You could choose to have two sidebars (a three-column theme) or none if you want.
			Unless otherwise overridden in the other options, this will be applied to your entire blog.",
		"id" => "suf_sidebar_count",
		"parent" => "default",
		"grouping" => "sidebars",
		"type" => "radio",
		"options" => array("0" => "0 (Zero)", "1" => "1 (One)", "2" => "2 (Two)"),
		"std" => "1"),

	array("name" => "Position of Sidebar 1",
		"desc" => "If you have two sidebars enabled and both are positioned on the same side, this sidebar will be the outer one. " .
				"If you have only one sidebar enabled, this will control the position of that sidebar.",
		"id" => "suf_sidebar_alignment",
		"parent" => "default",
		"grouping" => "sidebars",
		"type" => "radio",
		"options" => array("left" => "Left", "right" => "Right"),
		"std" => "right"),

	array("name" => "Position of Sidebar 2",
		"desc" => "If you have two sidebars enabled and both are positioned on the same side, this sidebar will be the inner one. " .
				"If you have only one sidebar enabled, this setting will be ignored.",
		"id" => "suf_sidebar_2_alignment",
		"parent" => "default",
		"grouping" => "sidebars",
		"type" => "radio",
		"options" => array("left" => "Left", "right" => "Right"),
		"std" => "right"),

	array("name" => "Widths",
		"category" => "widths",
		"parent" => "default",
		"type" => "sub-section-4",),

	array("name" => "Default sizes / margins for page elements?",
		"desc" => "You can decide to go with the sizes and margins (gaps) defined with the theme for different page elements or pick your own. " .
				"If you choose custom styles then the settings you make here will override the theme's settings.",
		"id" => "suf_size_options",
		"parent" => "default",
		"grouping" => "widths",
		"type" => "radio",
		"note" => "Please set this option to \"Custom styles\" if you want to override the theme's settings for the header.",
		"options" => array("theme" => "Theme sizes and margins",
			"custom" => "Custom sizes and margins"),
		"std" => "custom"),

	array("name" => "Page Width Type",
		"desc" => "Your page can be fixed width or fluid/elastic width",
		"id" => "suf_wrapper_width_type",
		"parent" => "default",
		"grouping" => "widths",
		"type" => "radio",
		"options" => array("fixed" => "Fixed width", "fluid" => "Fluid/Flexible width"),
		"std" => "fixed"),

	array("name" => "Fluid width settings",
		"desc" => "In the fluid width layout your sidebars have a fixed width, while the overall width of your page is a percentage of the browser window's width.",
		"category" => "size-flexible",
		"parent" => "default",
		"type" => "sub-section-4",),

	array("name" => "Width of page",
		"id" => "suf_wrapper_width_flex",
		"parent" => "default",
		"grouping" => "size-flexible",
		"type" => "slider",
		"options" => array("range" => "min", "min" => 25, "max" => 100, "step" => 1, "size" => "400px", "unit" => "%"),
		"std" => 75),

	array("name" => "Maximum width",
		"desc" => "Set this value so that your typography stays consistent on large screens.",
		"id" => "suf_wrapper_width_flex_max",
		"parent" => "default",
		"grouping" => "size-flexible",
		"type" => "text",
		"hint" => "Enter the number of pixels here (don't enter 'px'). Value will be set to a default if blank or incompatible.",
		"std" => "1200"),

	array("name" => "Minimum width",
		"desc" => "Set this value so that your typography stays consistent on small screens.",
		"id" => "suf_wrapper_width_flex_min",
		"parent" => "default",
		"grouping" => "size-flexible",
		"type" => "text",
		"hint" => "Enter the number of pixels here (don't enter 'px'). Value will be set to a default if blank or incompatible.",
		"std" => "600"),

	array("name" => "Fixed width settings",
		"desc" => "In the fixed width layout the components of your page have widths fixed in pixels, irrespective of the size of your browser window.",
		"category" => "size-fixed",
		"parent" => "default",
		"type" => "sub-section-4",),

	array("name" => "Overall Page Width",
		"desc" => "Suffusion comes with 3 preset page width options: 800px, 1000px and 1200px. You can also define a custom width if you please, or allow the width of the page to be determined by the width of its main components like the sidebars and the main content column.
				Due to difficulties with fitting things on the page, the minimum size allowed is 600px. If you enter something less than 600, it is considered to be 600.",
		"id" => "suf_wrapper_width_preset",
		"parent" => "default",
		"grouping" => "size-fixed",
		"type" => "radio",
		"options" => array("800" => "800px", "1000" => "1000px", "1200" => "1200px",
			"custom" => "Custom width (defined below)", "custom-components" => "Custom width, but constructed from individual components (defined below)"),
		"std" => "1000"),

	array("name" => "Custom value for page width",
		"desc" => "If you have selected \"Custom width\" above, you can set the width here. Please enter the width in pixels. <b>Do not enter \"px\".</b>
				Anything below 600 will be treated as 600. Note that if you are setting a width over here with the \"Custom width\" selection in place, the widths of the individual components like the main column, the sidebars etc. are auto-calculated",
		"id" => "suf_wrapper_width",
		"parent" => "default",
		"grouping" => "size-fixed",
		"type" => "text",
		"hint" => "Enter the number of pixels here (don't enter 'px'). Non-integers will be ignored. Incompatible values will be treated as 1000",
		"std" => "1000"),

	array("name" => "Custom component width - Custom value for main column width",
		"desc" => "If you have selected \"Custom width, but constructed from individual components\" above, you can set the width here for the main column.
				Please enter the width in pixels. <b>Do not enter \"px\".</b>
				Anything below 380 will be treated as 380. ",
		"id" => "suf_main_col_width",
		"parent" => "default",
		"grouping" => "size-fixed",
		"type" => "text",
		"hint" => "Enter the number of pixels here (don't enter 'px'). Non-integers will be ignored. Incompatible values will be treated as 725",
		"std" => "725"),

	array("name" => "Sidebar width settings",
		"desc" => "Sidebar widths are relevant in the fluid width layout and in the fixed width layout with the \"Custom width, but constructed from individual components\" selection.",
		"category" => "size-sb",
		"parent" => "default",
		"type" => "sub-section-4",),

	array("name" => "Custom component width - Custom value for width of first sidebar",
		"desc" => "If you have fluid widths or fixed widths with \"Custom width, but constructed from individual components\" above, you can set the width here for the first sidebar.
				Please enter the width in pixels. <b>Do not enter \"px\".</b>
				Anything below 95 will be treated as 95. ",
		"id" => "suf_sb_1_width",
		"parent" => "default",
		"grouping" => "size-sb",
		"type" => "text",
		"hint" => "Enter the number of pixels here (don't enter 'px'). Non-integers will be ignored. Incompatible values will be treated as 260",
		"std" => "260"),

	array("name" => "Custom component width - Custom value for width of second sidebar",
		"desc" => "If you have fluid widths or fixed widths with \"Custom width, but constructed from individual components\" above, you can set the width here for the second sidebar.
				Please enter the width in pixels. <b>Do not enter \"px\".</b>
				Anything below 95 will be treated as 95. ",
		"id" => "suf_sb_2_width",
		"parent" => "default",
		"grouping" => "size-sb",
		"type" => "text",
		"hint" => "Enter the number of pixels here (don't enter 'px'). Non-integers will be ignored. Incompatible values will be treated as 260",
		"std" => "260"),

	array("name" => "No Sidebars",
		"type" => "sub-section-3",
		"category" => "no-sidebars",
		"parent" => "layouts"
	),

	array("name" => "The \"No Sidebars\" layout",
		"desc" => "You can use the \"No Sidebars\" layout if you have a post / page where you don't want sidebars to show up, but the rest of your blog has sidebars enabled.
				To set up posts / pages with this layout, select the \"No Sidebars\" layout while creating or updating a post / page.",
		"parent" => "no-sidebars",
		"type" => "blurb"
	),

	array("name" => "Enable Widget Area Below Header?",
		"desc" => "By default the \"Widget Area Below Header\" is enabled in the \"No Sidebars\" layout. You can change it: ",
		"id" => "suf_ns_wabh_enabled",
		"parent" => "no-sidebars",
		"type" => "radio",
		"options" => array("enabled" => "Widget Area below Header enabled",
			"not-enabled" => "Widget Area below Header not enabled"),
		"std" => "enabled"),

	array("name" => "Enable Widget Area Above Footer?",
		"desc" => "By default the \"Widget Area Above Footer\" is enabled in the \"No Sidebars\" layout. You can change it: ",
		"id" => "suf_ns_waaf_enabled",
		"parent" => "no-sidebars",
		"type" => "radio",
		"options" => array("enabled" => "Widget Area above Footer enabled",
			"not-enabled" => "Widget Area above Footer not enabled"),
		"std" => "enabled"),

	array("name" => "1 Left Sidebar",
		"type" => "sub-section-3",
		"category" => "1l-sidebar",
		"parent" => "layouts"
	),

	array("name" => "The \"1 Left Sidebar\" layout",
		"desc" => "You can use this layout if you have a post / page where you want a single sidebar to show up on the left.
				To set up posts / pages with this layout, select the \"1 Left Sidebar\" layout while creating or updating a post / page.",
		"parent" => "1l-sidebar",
		"type" => "blurb"
	),

	array("name" => "Page Width Type",
		"desc" => "Your page can be fixed width or fluid/elastic width",
		"id" => "suf_1l_wrapper_width_type",
		"parent" => "1l-sidebar",
		"type" => "radio",
		"options" => array("fixed" => "Fixed width", "fluid" => "Fluid/Flexible width"),
		"std" => "fixed"),

	array("name" => "Fluid width settings",
		"desc" => "In the fluid width layout your sidebars have a fixed width, while the overall width of your page is a percentage of the browser window's width.",
		"category" => "1l-size-flexible",
		"parent" => "1l-sidebar",
		"type" => "sub-section-4",),

	array("name" => "Width of page",
		"id" => "suf_1l_wrapper_width_flex",
		"parent" => "1l-sidebar",
		"grouping" => "1l-size-flexible",
		"type" => "slider",
		"options" => array("range" => "min", "min" => 25, "max" => 100, "step" => 1, "size" => "400px", "unit" => "%"),
		"std" => 75),

	array("name" => "Maximum width",
		"desc" => "Set this value so that your typography stays consistent on large screens.",
		"id" => "suf_1l_wrapper_width_flex_max",
		"parent" => "1l-sidebar",
		"grouping" => "1l-size-flexible",
		"type" => "text",
		"hint" => "Enter the number of pixels here (don't enter 'px'). Value will be set to a default if blank or incompatible.",
		"std" => "1200"),

	array("name" => "Minimum width",
		"desc" => "Set this value so that your typography stays consistent on small screens.",
		"id" => "suf_1l_wrapper_width_flex_min",
		"parent" => "1l-sidebar",
		"grouping" => "1l-size-flexible",
		"type" => "text",
		"hint" => "Enter the number of pixels here (don't enter 'px'). Value will be set to a default if blank or incompatible.",
		"std" => "600"),

	array("name" => "Fixed width settings",
		"desc" => "In the fixed width layout the components of your page have widths fixed in pixels, irrespective of the size of your browser window.",
		"category" => "1l-size-fixed",
		"parent" => "1l-sidebar",
		"type" => "sub-section-4",),

	array("name" => "Overall Page Width",
		"desc" => "Suffusion comes with 3 preset page width options: 800px, 1000px and 1200px. You can also define a custom width if you please, or allow the width of the page to be determined by the width of its main components like the sidebars and the main content column.
				Due to difficulties with fitting things on the page, the minimum size allowed is 600px. If you enter something less than 600, it is considered to be 600.",
		"id" => "suf_1l_wrapper_width_preset",
		"parent" => "1l-sidebar",
		"grouping" => "1l-size-fixed",
		"type" => "radio",
		"options" => array("800" => "800px", "1000" => "1000px", "1200" => "1200px",
			"custom" => "Custom width (defined below)", "custom-components" => "Custom width, but constructed from individual components (defined below)"),
		"std" => "1000"),

	array("name" => "Custom value for page width",
		"desc" => "If you have selected \"Custom width\" above, you can set the width here. Please enter the width in pixels. <b>Do not enter \"px\".</b>
				Anything below 600 will be treated as 600. Note that if you are setting a width over here with the \"Custom width\" selection in place, the widths of the individual components like the main column, the sidebars etc. are auto-calculated",
		"id" => "suf_1l_wrapper_width",
		"parent" => "1l-sidebar",
		"grouping" => "1l-size-fixed",
		"type" => "text",
		"hint" => "Enter the number of pixels here (don't enter 'px'). Non-integers will be ignored. Incompatible values will be treated as 1000",
		"std" => "1000"),

	array("name" => "Custom component width - Custom value for main column width",
		"desc" => "If you have selected \"Custom width, but constructed from individual components\" above, you can set the width here for the main column.
				Please enter the width in pixels. <b>Do not enter \"px\".</b> Anything below 380 will be treated as 380. ",
		"id" => "suf_1l_main_col_width",
		"parent" => "1l-sidebar",
		"grouping" => "1l-size-fixed",
		"type" => "text",
		"hint" => "Enter the number of pixels here (don't enter 'px'). Non-integers will be ignored. Incompatible values will be treated as 725",
		"std" => "725"),

	array("name" => "Custom component width - Custom value for width of sidebar",
		"desc" => "If you have selected \"Fluid width\" or \"Custom width, but constructed from individual components\" above, you can set the width here for the first sidebar.
				Please enter the width in pixels. <b>Do not enter \"px\".</b> Anything below 95 will be treated as 95. ",
		"id" => "suf_1l_sb_1_width",
		"parent" => "1l-sidebar",
		"type" => "text",
		"hint" => "Enter the number of pixels here (don't enter 'px'). Non-integers will be ignored. Incompatible values will be treated as 260",
		"std" => "260"),

	array("name" => "1 Right Sidebar",
		"type" => "sub-section-3",
		"category" => "1r-sidebar",
		"parent" => "layouts"
	),

	array("name" => "The \"1 Right Sidebar\" layout",
		"desc" => "You can use this layout if you have a post / page where you want a single sidebar to show up on the right.
				To set up posts / pages with this layout, select the \"1 Right Sidebar\" layout while creating or updating a post / page.",
		"parent" => "1r-sidebar",
		"type" => "blurb"
	),

	array("name" => "Page Width Type",
		"desc" => "Your page can be fixed width or fluid/elastic width",
		"id" => "suf_1r_wrapper_width_type",
		"parent" => "1r-sidebar",
		"type" => "radio",
		"options" => array("fixed" => "Fixed width", "fluid" => "Fluid/Flexible width"),
		"std" => "fixed"),

	array("name" => "Fluid width settings",
		"desc" => "In the fluid width layout your sidebars have a fixed width, while the overall width of your page is a percentage of the browser window's width.",
		"category" => "1r-size-flexible",
		"parent" => "1r-sidebar",
		"type" => "sub-section-4",),

	array("name" => "Width of page",
		"id" => "suf_1r_wrapper_width_flex",
		"parent" => "1r-sidebar",
		"grouping" => "1r-size-flexible",
		"type" => "slider",
		"options" => array("range" => "min", "min" => 25, "max" => 100, "step" => 1, "size" => "400px", "unit" => "%"),
		"std" => 75),

	array("name" => "Maximum width",
		"desc" => "Set this value so that your typography stays consistent on large screens.",
		"id" => "suf_1r_wrapper_width_flex_max",
		"parent" => "1r-sidebar",
		"grouping" => "1r-size-flexible",
		"type" => "text",
		"hint" => "Enter the number of pixels here (don't enter 'px'). Value will be set to a default if blank or incompatible.",
		"std" => "1200"),

	array("name" => "Minimum width",
		"desc" => "Set this value so that your typography stays consistent on small screens.",
		"id" => "suf_1r_wrapper_width_flex_min",
		"parent" => "1r-sidebar",
		"grouping" => "1r-size-flexible",
		"type" => "text",
		"hint" => "Enter the number of pixels here (don't enter 'px'). Value will be set to a default if blank or incompatible.",
		"std" => "600"),

	array("name" => "Fixed width settings",
		"desc" => "In the fixed width layout the components of your page have widths fixed in pixels, irrespective of the size of your browser window.",
		"category" => "1r-size-fixed",
		"parent" => "1r-sidebar",
		"type" => "sub-section-4",),

	array("name" => "Overall Page Width",
		"desc" => "Suffusion comes with 3 preset page width options: 800px, 1000px and 1200px. You can also define a custom width if you please, or allow the width of the page to be determined by the width of its main components like the sidebars and the main content column.
				Due to difficulties with fitting things on the page, the minimum size allowed is 600px. If you enter something less than 600, it is considered to be 600.",
		"id" => "suf_1r_wrapper_width_preset",
		"parent" => "1r-sidebar",
		"grouping" => "1r-size-fixed",
		"type" => "radio",
		"options" => array("800" => "800px", "1000" => "1000px", "1200" => "1200px",
			"custom" => "Custom width (defined below)", "custom-components" => "Custom width, but constructed from individual components (defined below)"),
		"std" => "1000"),

	array("name" => "Custom value for page width",
		"desc" => "If you have selected \"Custom width\" above, you can set the width here. Please enter the width in pixels. <b>Do not enter \"px\".</b>
				Anything below 600 will be treated as 600. Also note that if you are setting a width over here with the \"Custom width\" selection in place, the widths of the individual components like the main column, the sidebars etc. are auto-calculated",
		"id" => "suf_1r_wrapper_width",
		"parent" => "1r-sidebar",
		"grouping" => "1r-size-fixed",
		"type" => "text",
		"hint" => "Enter the number of pixels here (don't enter 'px'). Non-integers will be ignored. Incompatible values will be treated as 1000",
		"std" => "1000"),

	array("name" => "Custom component width - Custom value for main column width",
		"desc" => "If you have selected \"Custom width, but constructed from individual components\" above, you can set the width here for the main column.
				Please enter the width in pixels. <b>Do not enter \"px\".</b>
				Anything below 380 will be treated as 380. ",
		"id" => "suf_1r_main_col_width",
		"parent" => "1r-sidebar",
		"grouping" => "1r-size-fixed",
		"type" => "text",
		"hint" => "Enter the number of pixels here (don't enter 'px'). Non-integers will be ignored. Incompatible values will be treated as 725",
		"std" => "725"),

	array("name" => "Custom component width - Custom value for width of sidebar",
		"desc" => "If you have selected \"Fluid width\" or \"Custom width, but constructed from individual components\" above, you can set the width here for the first sidebar.
				Please enter the width in pixels. <b>Do not enter \"px\".</b>
				Anything below 95 will be treated as 95.",
		"id" => "suf_1r_sb_1_width",
		"parent" => "1r-sidebar",
		"type" => "text",
		"hint" => "Enter the number of pixels here (don't enter 'px'). Non-integers will be ignored. Incompatible values will be treated as 260",
		"std" => "260"),

	array("name" => "1 Left, 1 Right Sidebar",
		"type" => "sub-section-3",
		"category" => "1l1r-sidebar",
		"parent" => "layouts"
	),

	array("name" => "The \"1 Left and 1 Right Sidebar\" layout",
		"desc" => "You can use this layout if you have a post / page where you want a single sidebar to show up on the left and right sides.
				To set up posts / pages with this layout, select the \"1 Left and 1 Right Sidebar\" layout while creating or updating a post / page.",
		"parent" => "1l1r-sidebar",
		"type" => "blurb"
	),

	array("name" => "Page Width Type",
		"desc" => "Your page can be fixed width or fluid/elastic width",
		"id" => "suf_1l1r_wrapper_width_type",
		"parent" => "1l1r-sidebar",
		"type" => "radio",
		"options" => array("fixed" => "Fixed width", "fluid" => "Fluid/Flexible width"),
		"std" => "fixed"),

	array("name" => "Fluid width settings",
		"desc" => "In the fluid width layout your sidebars have a fixed width, while the overall width of your page is a percentage of the browser window's width.",
		"category" => "1l1r-size-flexible",
		"parent" => "1l1r-sidebar",
		"type" => "sub-section-4",),

	array("name" => "Width of page",
		"id" => "suf_1l1r_wrapper_width_flex",
		"parent" => "1l1r-sidebar",
		"grouping" => "1l1r-size-flexible",
		"type" => "slider",
		"options" => array("range" => "min", "min" => 25, "max" => 100, "step" => 1, "size" => "400px", "unit" => "%"),
		"std" => 75),

	array("name" => "Maximum width",
		"desc" => "Set this value so that your typography stays consistent on large screens.",
		"id" => "suf_1l1r_wrapper_width_flex_max",
		"parent" => "1l1r-sidebar",
		"grouping" => "1l1r-size-flexible",
		"type" => "text",
		"hint" => "Enter the number of pixels here (don't enter 'px'). Value will be set to a default if blank or incompatible.",
		"std" => "1200"),

	array("name" => "Minimum width",
		"desc" => "Set this value so that your typography stays consistent on small screens.",
		"id" => "suf_1l1r_wrapper_width_flex_min",
		"parent" => "1l1r-sidebar",
		"grouping" => "1l1r-size-flexible",
		"type" => "text",
		"hint" => "Enter the number of pixels here (don't enter 'px'). Value will be set to a default if blank or incompatible.",
		"std" => "600"),

	array("name" => "Fixed width settings",
		"desc" => "In the fixed width layout the components of your page have widths fixed in pixels, irrespective of the size of your browser window.",
		"category" => "1l1r-size-fixed",
		"parent" => "1l1r-sidebar",
		"type" => "sub-section-4",),

	array("name" => "Overall Page Width",
		"desc" => "Suffusion comes with 3 preset page width options: 800px, 1000px and 1200px. You can also define a custom width if you please, or allow the width of the page to be determined by the width of its main components like the sidebars and the main content column.
				Due to difficulties with fitting things on the page, the minimum size allowed is 600px. If you enter something less than 600, it is considered to be 600.",
		"id" => "suf_1l1r_wrapper_width_preset",
		"parent" => "1l1r-sidebar",
		"grouping" => "1l1r-size-fixed",
		"type" => "radio",
		"options" => array("800" => "800px", "1000" => "1000px", "1200" => "1200px",
			"custom" => "Custom width (defined below)", "custom-components" => "Custom width, but constructed from individual components (defined below)"),
		"std" => "1000"),

	array("name" => "Custom value for page width",
		"desc" => "If you have selected \"Custom width\" above, you can set the width here. Please enter the width in pixels. <b>Do not enter \"px\".</b>
				Anything below 600 will be treated as 600. Also note that if you are setting a width over here with the \"Custom width\" selection in place, the widths of the individual components like the main column, the sidebars etc. are auto-calculated",
		"id" => "suf_1l1r_wrapper_width",
		"parent" => "1l1r-sidebar",
		"grouping" => "1l1r-size-fixed",
		"type" => "text",
		"hint" => "Enter the number of pixels here (don't enter 'px'). Non-integers will be ignored. Incompatible values will be treated as 1000",
		"std" => "1000"),

	array("name" => "Custom component width - Custom value for main column width",
		"desc" => "If you have selected \"Custom width, but constructed from individual components\" above, you can set the width here for the main column.
				Please enter the width in pixels. <b>Do not enter \"px\".</b>
				Anything below 380 will be treated as 380.",
		"id" => "suf_1l1r_main_col_width",
		"parent" => "1l1r-sidebar",
		"grouping" => "1l1r-size-fixed",
		"type" => "text",
		"hint" => "Enter the number of pixels here (don't enter 'px'). Non-integers will be ignored. Incompatible values will be treated as 725",
		"std" => "725"),

	array("name" => "Sidebar width settings",
		"desc" => "Sidebar widths are relevant in the fluid width layout and in the fixed width layout with the \"Custom width, but constructed from individual components\" selection.",
		"category" => "1l1r-size-sb",
		"parent" => "1l1r-sidebar",
		"type" => "sub-section-4",),

	array("name" => "Custom component width - Custom value for width of left sidebar",
		"desc" => "If you have selected \"Custom width, but constructed from individual components\" above, you can set the width here for the first sidebar.
				Please enter the width in pixels. <b>Do not enter \"px\".</b>
				Anything below 95 will be treated as 95.",
		"id" => "suf_1l1r_sb_1_width",
		"parent" => "1l1r-sidebar",
		"grouping" => "1l1r-size-sb",
		"type" => "text",
		"hint" => "Enter the number of pixels here (don't enter 'px'). Non-integers will be ignored. Incompatible values will be treated as 260",
		"std" => "260"),

	array("name" => "Custom component width - Custom value for width of right sidebar",
		"desc" => "If you have selected \"Custom width, but constructed from individual components\" above, you can set the width here for the second sidebar.
				Please enter the width in pixels. <b>Do not enter \"px\".</b>
				Anything below 95 will be treated as 95.",
		"id" => "suf_1l1r_sb_2_width",
		"parent" => "1l1r-sidebar",
		"grouping" => "1l1r-size-sb",
		"type" => "text",
		"hint" => "Enter the number of pixels here (don't enter 'px'). Non-integers will be ignored. Incompatible values will be treated as 260",
		"std" => "260"),

	array("name" => "2 Left Sidebars",
		"type" => "sub-section-3",
		"category" => "2l-sidebars",
		"parent" => "layouts"
	),

	array("name" => "The \"2 Left Sidebars\" layout",
		"desc" => "You can use this layout if you have a post / page where you want two sidebars to show up on the left.
				To set up posts / pages with this layout, select the \"2 Left Sidebars\" layout while creating or updating a post / page.",
		"parent" => "2l-sidebars",
		"type" => "blurb"
	),

	array("name" => "Page Width Type",
		"desc" => "Your page can be fixed width or fluid/elastic width",
		"id" => "suf_2l_wrapper_width_type",
		"parent" => "2l-sidebars",
		"type" => "radio",
		"options" => array("fixed" => "Fixed width", "fluid" => "Fluid/Flexible width"),
		"std" => "fixed"),

	array("name" => "Fluid width settings",
		"desc" => "In the fluid width layout your sidebars have a fixed width, while the overall width of your page is a percentage of the browser window's width.",
		"category" => "2l-size-flexible",
		"parent" => "2l-sidebars",
		"type" => "sub-section-4",),

	array("name" => "Width of page",
		"id" => "suf_2l_wrapper_width_flex",
		"parent" => "2l-sidebars",
		"grouping" => "2l-size-flexible",
		"type" => "slider",
		"options" => array("range" => "min", "min" => 25, "max" => 100, "step" => 1, "size" => "400px", "unit" => "%"),
		"std" => 75),

	array("name" => "Maximum width",
		"desc" => "Set this value so that your typography stays consistent on large screens.",
		"id" => "suf_2l_wrapper_width_flex_max",
		"parent" => "2l-sidebars",
		"grouping" => "2l-size-flexible",
		"type" => "text",
		"hint" => "Enter the number of pixels here (don't enter 'px'). Value will be set to a default if blank or incompatible.",
		"std" => "1200"),

	array("name" => "Minimum width",
		"desc" => "Set this value so that your typography stays consistent on small screens.",
		"id" => "suf_2l_wrapper_width_flex_min",
		"parent" => "2l-sidebars",
		"grouping" => "2l-size-flexible",
		"type" => "text",
		"hint" => "Enter the number of pixels here (don't enter 'px'). Value will be set to a default if blank or incompatible.",
		"std" => "600"),

	array("name" => "Fixed width settings",
		"desc" => "In the fixed width layout the components of your page have widths fixed in pixels, irrespective of the size of your browser window.",
		"category" => "2l-size-fixed",
		"parent" => "2l-sidebars",
		"type" => "sub-section-4",),

	array("name" => "Overall Page Width",
		"desc" => "Suffusion comes with 3 preset page width options: 800px, 1000px and 1200px. You can also define a custom width if you please, or allow the width of the page to be determined by the width of its main components like the sidebars and the main content column.
				Due to difficulties with fitting things on the page, the minimum size allowed is 600px. If you enter something less than 600, it is considered to be 600.",
		"id" => "suf_2l_wrapper_width_preset",
		"parent" => "2l-sidebars",
		"grouping" => "2l-size-fixed",
		"type" => "radio",
		"options" => array("800" => "800px", "1000" => "1000px", "1200" => "1200px",
			"custom" => "Custom width (defined below)", "custom-components" => "Custom width, but constructed from individual components (defined below)"),
		"std" => "1000"),

	array("name" => "Custom value for page width",
		"desc" => "If you have selected \"Custom width\" above, you can set the width here. Please enter the width in pixels. <b>Do not enter \"px\".</b>
				Anything below 600 will be treated as 600. Also note that if you are setting a width over here with the \"Custom width\" selection in place, the widths of the individual components like the main column, the sidebars etc. are auto-calculated",
		"id" => "suf_2l_wrapper_width",
		"parent" => "2l-sidebars",
		"grouping" => "2l-size-fixed",
		"type" => "text",
		"hint" => "Enter the number of pixels here (don't enter 'px'). Non-integers will be ignored. Incompatible values will be treated as 1000",
		"std" => "1000"),

	array("name" => "Custom component width - Custom value for main column width",
		"desc" => "If you have selected \"Custom width, but constructed from individual components\" above, you can set the width here for the main column.
				Please enter the width in pixels. <b>Do not enter \"px\".</b>
				Anything below 380 will be treated as 380.",
		"id" => "suf_2l_main_col_width",
		"parent" => "2l-sidebars",
		"grouping" => "2l-size-fixed",
		"type" => "text",
		"hint" => "Enter the number of pixels here (don't enter 'px'). Non-integers will be ignored. Incompatible values will be treated as 725",
		"std" => "725"),

	array("name" => "Sidebar width settings",
		"desc" => "Sidebar widths are relevant in the fluid width layout and in the fixed width layout with the \"Custom width, but constructed from individual components\" selection.",
		"category" => "2l-size-sb",
		"parent" => "2l-sidebars",
		"type" => "sub-section-4",),

	array("name" => "Custom component width - Custom value for width of first sidebar",
		"desc" => "If you have selected \"Fluid width\" or \"Custom width, but constructed from individual components\" above, you can set the width here for the first sidebar.
				Please enter the width in pixels. <b>Do not enter \"px\".</b>
				Anything below 95 will be treated as 95.",
		"id" => "suf_2l_sb_1_width",
		"parent" => "2l-sidebars",
		"grouping" => "2l-size-sb",
		"type" => "text",
		"hint" => "Enter the number of pixels here (don't enter 'px'). Non-integers will be ignored. Incompatible values will be treated as 260",
		"std" => "260"),

	array("name" => "Custom component width - Custom value for width of second sidebar",
		"desc" => "If you have selected \"Fluid width\" or \"Custom width, but constructed from individual components\" above, you can set the width here for the second sidebar.
				Please enter the width in pixels. <b>Do not enter \"px\".</b> Anything below 95 will be treated as 95.",
		"id" => "suf_2l_sb_2_width",
		"parent" => "2l-sidebars",
		"grouping" => "2l-size-sb",
		"type" => "text",
		"hint" => "Enter the number of pixels here (don't enter 'px'). Non-integers will be ignored. Incompatible values will be treated as 260",
		"std" => "260"),

	array("name" => "2 Right Sidebars",
		"type" => "sub-section-3",
		"category" => "2r-sidebars",
		"parent" => "layouts"
	),

	array("name" => "The \"2 Right Sidebars\" layout",
		"desc" => "You can use this layout if you have a post / page where you want two sidebars to show up on the right.
				To set up posts / pages with this layout, select the \"2 Right Sidebars\" layout while creating or updating a post / page.",
		"parent" => "2r-sidebars",
		"type" => "blurb"
	),

	array("name" => "Page Width Type",
		"desc" => "Your page can be fixed width or fluid/elastic width",
		"id" => "suf_2r_wrapper_width_type",
		"parent" => "2r-sidebars",
		"type" => "radio",
		"options" => array("fixed" => "Fixed width", "fluid" => "Fluid/Flexible width"),
		"std" => "fixed"),

	array("name" => "Fluid width settings",
		"desc" => "In the fluid width layout your sidebars have a fixed width, while the overall width of your page is a percentage of the browser window's width.",
		"category" => "2r-size-flexible",
		"parent" => "2r-sidebars",
		"type" => "sub-section-4",),

	array("name" => "Width of page",
		"id" => "suf_2r_wrapper_width_flex",
		"parent" => "2r-sidebars",
		"grouping" => "2r-size-flexible",
		"type" => "slider",
		"options" => array("range" => "min", "min" => 25, "max" => 100, "step" => 1, "size" => "400px", "unit" => "%"),
		"std" => 75),

	array("name" => "Maximum width",
		"desc" => "Set this value so that your typography stays consistent on large screens.",
		"id" => "suf_2r_wrapper_width_flex_max",
		"parent" => "2r-sidebars",
		"grouping" => "2r-size-flexible",
		"type" => "text",
		"hint" => "Enter the number of pixels here (don't enter 'px'). Value will be set to a default if blank or incompatible.",
		"std" => "1200"),

	array("name" => "Minimum width",
		"desc" => "Set this value so that your typography stays consistent on small screens.",
		"id" => "suf_2r_wrapper_width_flex_min",
		"parent" => "2r-sidebars",
		"grouping" => "2r-size-flexible",
		"type" => "text",
		"hint" => "Enter the number of pixels here (don't enter 'px'). Value will be set to a default if blank or incompatible.",
		"std" => "600"),

	array("name" => "Fixed width settings",
		"desc" => "In the fixed width layout the components of your page have widths fixed in pixels, irrespective of the size of your browser window.",
		"category" => "2r-size-fixed",
		"parent" => "2r-sidebars",
		"type" => "sub-section-4",),

	array("name" => "Overall Page Width",
		"desc" => "Suffusion comes with 3 preset page width options: 800px, 1000px and 1200px. You can also define a custom width if you please, or allow the width of the page to be determined by the width of its main components like the sidebars and the main content column.
				Due to difficulties with fitting things on the page, the minimum size allowed is 600px. If you enter something less than 600, it is considered to be 600.",
		"id" => "suf_2r_wrapper_width_preset",
		"parent" => "2r-sidebars",
		"grouping" => "2r-size-fixed",
		"type" => "radio",
		"options" => array("800" => "800px", "1000" => "1000px", "1200" => "1200px",
			"custom" => "Custom width (defined below)", "custom-components" => "Custom width, but constructed from individual components (defined below)"),
		"std" => "1000"),

	array("name" => "Custom value for page width",
		"desc" => "If you have selected \"Custom width\" above, you can set the width here. Please enter the width in pixels. <b>Do not enter \"px\".</b>
				Anything below 600 will be treated as 600. Also note that if you are setting a width over here with the \"Custom width\" selection in place, the widths of the individual components like the main column, the sidebars etc. are auto-calculated",
		"id" => "suf_2r_wrapper_width",
		"parent" => "2r-sidebars",
		"grouping" => "2r-size-fixed",
		"type" => "text",
		"hint" => "Enter the number of pixels here (don't enter 'px'). Non-integers will be ignored. Incompatible values will be treated as 1000",
		"std" => "1000"),

	array("name" => "Custom component width - Custom value for main column width",
		"desc" => "If you have selected \"Custom width, but constructed from individual components\" above, you can set the width here for the main column.
				Please enter the width in pixels. <b>Do not enter \"px\".</b>
				Anything below 380 will be treated as 380.",
		"id" => "suf_2r_main_col_width",
		"parent" => "2r-sidebars",
		"grouping" => "2r-size-fixed",
		"type" => "text",
		"hint" => "Enter the number of pixels here (don't enter 'px'). Non-integers will be ignored. Incompatible values will be treated as 725",
		"std" => "725"),

	array("name" => "Sidebar width settings",
		"desc" => "Sidebar widths are relevant in the fluid width layout and in the fixed width layout with the \"Custom width, but constructed from individual components\" selection.",
		"category" => "2r-size-sb",
		"parent" => "2r-sidebars",
		"type" => "sub-section-4",),

	array("name" => "Custom component width - Custom value for width of first sidebar",
		"desc" => "If you have selected \"Fluid width\" or \"Custom width, but constructed from individual components\" above, you can set the width here for the first sidebar.
				Please enter the width in pixels. <b>Do not enter \"px\".</b>
				Anything below 95 will be treated as 95.",
		"id" => "suf_2r_sb_1_width",
		"parent" => "2r-sidebars",
		"grouping" => "2r-size-sb",
		"type" => "text",
		"hint" => "Enter the number of pixels here (don't enter 'px'). Non-integers will be ignored. Incompatible values will be treated as 260",
		"std" => "260"),

	array("name" => "Custom component width - Custom value for width of second sidebar",
		"desc" => "If you have selected \"Fluid width\" or \"Custom width, but constructed from individual components\" above, you can set the width here for the second sidebar.
				Please enter the width in pixels. <b>Do not enter \"px\".</b>
				Anything below 95 will be treated as 95.",
		"id" => "suf_2r_sb_2_width",
		"parent" => "2r-sidebars",
		"grouping" => "2r-size-sb",
		"type" => "text",
		"hint" => "Enter the number of pixels here (don't enter 'px'). Non-integers will be ignored. Incompatible values will be treated as 260",
		"std" => "260"),

	array("name" => "Responsive Layouts",
		"type" => "sub-section-3",
		"category" => "responsive",
		"parent" => "layouts"
	),

	array("name" => "Enable Responsive Layouts",
		"desc" => "Enable responsive layouts",
		"id" => "suf_enable_responsive",
		"parent" => "responsive",
		"type" => "checkbox",
		'std' => '',
	),

	array("name" => "Breakpoints",
		"desc" => "Check the breakpoints that you want to enable",
		"id" => "suf_responsive_stops",
		"parent" => "responsive",
		"type" => "multi-select",
		"options" => suffusion_get_formatted_options_array(
			array(
				'980px' => '980px',
				'650px' => '650px',
				'480px' => '480px',
				'320px' => '320px',
				'240px' => '240px',
			)),
		"std" => '980px,650px,480px,320px,240px'
	),

	array("name" => "Scaling",
		"desc" => "Don't allow pinch and zoom on touch devices. Selecting this will fix <a href='http://filamentgroup.com/examples/iosScaleBug/'>a bug on mobile Safari</a>.",
		"id" => "suf_responsive_prevent_user_scaling",
		"parent" => "responsive",
		"type" => "checkbox",
		'std' => '',
	),

	array("name" => "Switches",
		"desc" => "Select the widths at which you want the default behaviour to change",
		"category" => "responsive-switches",
		"parent" => "responsive",
		"type" => "sub-section-4",),

	array("name" => "Header Foreground Images (Logos)",
		"desc" => "Resize header foreground images (logos) proportionately",
		"id" => "suf_responsive_scale_header",
		"parent" => "responsive",
		"grouping" => "responsive-switches",
		"type" => "checkbox",
		'std' => '',
	),

	array("name" => "Navigation Menu",
		"desc" => "If your browser window is narrower than the following, the navigation menus become \"Select\" lists. Note that a mega-menu is not displayed in a select list:",
		"id" => "suf_responsive_nav_switch",
		"parent" => "responsive",
		"grouping" => "responsive-switches",
		"type" => "select",
		"options" => array(
			'always' => 'Always',
			'240px' => '240px',
			'320px' => '320px',
			'480px' => '480px',
			'650px' => '650px',
			'980px' => '980px',
			'never' => 'Never',
		),
		"std" => '480px'
	),

	array("name" => "Excerpt thumbnails",
		"desc" => "If your browser window is narrower than the following, the thumbnails in excerpts appear above the text:",
		"id" => "suf_responsive_thumb_switch",
		"parent" => "responsive",
		"grouping" => "responsive-switches",
		"type" => "select",
		"options" => array(
			'always' => 'Always',
			'240px' => '240px',
			'320px' => '320px',
			'480px' => '480px',
			'650px' => '650px',
			'980px' => '980px',
			'never' => 'Never',
		),
		"std" => '480px'
	),

	array("name" => "Pullout-style bylines",
		"desc" => "If your browser window is narrower than the following, the pullout-style bylines appear below the content:",
		"id" => "suf_responsive_pullout_switch",
		"parent" => "responsive",
		"grouping" => "responsive-switches",
		"type" => "select",
		"options" => array(
			'always' => 'Always',
			'240px' => '240px',
			'320px' => '320px',
			'480px' => '480px',
			'650px' => '650px',
			'980px' => '980px',
			'never' => 'Never',
		),
		"std" => '480px'
	),

/*	array("name" => "Magazine Template Headline Box",
		"desc" => "If your browser window is narrower than the following, the headlines will appear below the thumbnail:",
		"id" => "suf_responsive_headline_box_switch",
		"parent" => "responsive",
		"grouping" => "responsive-switches",
		"type" => "select",
		"options" => array(
			'always' => 'Always',
			'240px' => '240px',
			'320px' => '320px',
			'480px' => '480px',
			'650px' => '650px',
			'980px' => '980px',
			'never' => 'Never',
		),
		"std" => '480px'
	),*/

	array("name" => "240px",
		"desc" => "Control general settings for screens narrower than 240px",
		"category" => "responsive-240",
		"parent" => "responsive",
		"type" => "sub-section-4",),

	array("name" => "Sidebar display",
		"desc" => "If sidebars are enabled, how do you want to show them?",
		"id" => "suf_responsive_240_sb",
		"parent" => "responsive",
		"grouping" => "responsive-240",
		"type" => "select",
		"options" => array(
			'below' => 'Show below content',
			'kill' => 'Do not show sidebar(s)',
		),
		"std" => 'below'
	),

	array("name" => "320px",
		"desc" => "Control general settings for screens narrower than 320px",
		"category" => "responsive-320",
		"parent" => "responsive",
		"type" => "sub-section-4",),

	array("name" => "Sidebar display",
		"desc" => "If sidebars are enabled, how do you want to show them?",
		"id" => "suf_responsive_320_sb",
		"parent" => "responsive",
		"grouping" => "responsive-320",
		"type" => "select",
		"options" => array(
			'below' => 'Show below content',
			'below-beside' => 'Show below content, but if there are 2 sidebars, show them beside each other',
			'kill' => 'Do not show sidebar(s)',
		),
		"std" => 'below'
	),

	array("name" => "480px",
		"desc" => "Control general settings for screens narrower than 480px",
		"category" => "responsive-480",
		"parent" => "responsive",
		"type" => "sub-section-4",),

	array("name" => "Sidebar display",
		"desc" => "If sidebars are enabled, how do you want to show them?",
		"id" => "suf_responsive_480_sb",
		"parent" => "responsive",
		"grouping" => "responsive-480",
		"type" => "select",
		"options" => array(
			'below' => 'Show below content',
			'below-beside' => 'Show below content, but if there are 2 sidebars, show them beside each other',
			'kill' => 'Do not show sidebar(s)',
		),
		"std" => 'below'
	),

	array("name" => "Columns in components",
		"desc" => "Configure the number of columns in various components for screens narrower than 480px:",
		"id" => "suf_responsive_480_columns",
		"parent" => "responsive",
		"grouping" => "responsive-480",
		"type" => "associative-array",
		"options" => array(
			"Component" => suffusion_get_horizontal_components(),
			"Number of Columns" => array(
				'name' => 'columns',
				'type' => 'select',
				'options' => array(
					'1' => '1',
					'2' => '2',
					'3' => '3',
					'4' => '4',
					'5' => '5',
					'kill' => 'Hide',
				),
			),
		),
		"std" => ""),

	array("name" => "650px",
		"desc" => "Control general settings for screens narrower than 650px",
		"category" => "responsive-650",
		"parent" => "responsive",
		"type" => "sub-section-4",),

	array("name" => "Sidebar display",
		"desc" => "If sidebars are enabled, how do you want to show them?",
		"id" => "suf_responsive_650_sb",
		"parent" => "responsive",
		"grouping" => "responsive-650",
		"type" => "select",
		"options" => array(
			'below' => 'Show below content',
			'below-beside' => 'Show below content, but if there are 2 sidebars, show them beside each other',
			'in-position' => 'Show in original position',
			'kill' => 'Do not show sidebar(s)',
		),
		"std" => 'below-beside'
	),

	array("name" => "Columns in components",
		"desc" => "Configure the number of columns in various components for screens narrower than 650px:",
		"id" => "suf_responsive_650_columns",
		"parent" => "responsive",
		"grouping" => "responsive-650",
		"type" => "associative-array",
		"options" => array(
			"Component" => suffusion_get_horizontal_components(),
			"Number of Columns" => array(
				'name' => 'columns',
				'type' => 'select',
				'options' => array(
					'1' => '1',
					'2' => '2',
					'3' => '3',
					'4' => '4',
					'5' => '5',
					'kill' => 'Hide',
				),
			),
		),
		"std" => ""),

	array("name" => "980px",
		"desc" => "Control general settings for screens narrower than 980px",
		"category" => "responsive-980",
		"parent" => "responsive",
		"type" => "sub-section-4",),

	array("name" => "Sidebar display",
		"desc" => "If sidebars are enabled, how do you want to show them?",
		"id" => "suf_responsive_980_sb",
		"parent" => "responsive",
		"grouping" => "responsive-980",
		"type" => "select",
		"options" => array(
			'below' => 'Show below content',
			'below-beside' => 'Show below content, but if there are 2 sidebars, show them beside each other',
			'in-position' => 'Show in original position',
			'kill' => 'Do not show sidebar(s)',
		),
		"std" => 'in-position'
	),

	array("name" => "Columns in components",
		"desc" => "Configure the number of columns in various components for screens narrower than 980px:",
		"id" => "suf_responsive_980_columns",
		"parent" => "responsive",
		"grouping" => "responsive-980",
		"type" => "associative-array",
		"options" => array(
			"Component" => suffusion_get_horizontal_components(),
			"Number of Columns" => array(
				'name' => 'columns',
				'type' => 'select',
				'options' => array(
					'1' => '1',
					'2' => '2',
					'3' => '3',
					'4' => '4',
					'5' => '5',
					'kill' => 'Hide',
				),
			),
		),
		"std" => ""),

	array("name" => "Front / Blog Page Views",
		"type" => "sub-section-3",
		"category" => "blog-page",
		"parent" => "layouts"
	),

	array("name" => "Sidebar layout",
		"desc" => "The \"Blog\" page (set in <em>Settings &rarr; Reading</em>) will inherit the default number of sidebars. You can change this behavior:",
		"id" => "suf_blog_sidebar_count",
		"parent" => "blog-page",
		"type" => "radio",
		"options" => array("default" => "Get default sidebar layout", "0" => "0 (Zero) - Get \"No Sidebars\" settings",
			"1l" => "1 Left - Get \"1 Left Sidebar\" settings", "1r" => "1 Right - Get \"1 Right Sidebar\" settings",
			"1l1r" => "1 Left, 1 Right - Get \"1 Left, 1 Right Sidebar\" settings",
			"2l" => "2 Left - Get \"2 Left Sidebars\" settings", "2r" => "2 Right - Get \"2 Right Sidebars\" settings", ),
		"std" => "default"),

	array("name" => "Full posts / excerpts / list / tiles / mosaic",
		"id" => "suf_index_excerpt",
		"parent" => "blog-page",
		"type" => "radio",
		"options" => array("content" => "Display full content", "excerpt" => "Display excerpt", "list" => "Display list", "tiles" => 'Display tiles', "mosaic" => 'Display mosaic'),
		"std" => "content"),

	array("name" => "Number of Full content posts on Front Page",
		"desc" => "In the Excerpt, List and Tile display you can choose to show the first few posts with full content: ",
		"id" => "suf_index_fc_number",
		"parent" => "blog-page",
		"type" => "select",
		"options" => array("0" => "0 (Zero)", "1" => "1 (One)", "2" => "2 (Two)", "3" => "3 (Three)", "4" => "4 (Four)",
			"5" => "5 (Five)", "6" => "6 (Six)", "7" => "7 (Seven)", "8" => "8 (Eight)", "9" => "9 (Nine)", "10" => "10 (Ten)"),
		"std" => "0"),

	array("name" => "Category Views",
		"type" => "sub-section-3",
		"category" => "category-page",
		"parent" => "layouts"
	),

	array("name" => "Sidebar layout",
		"desc" => "A page displaying posts in a category will inherit the default number of sidebars. You can change this behavior:",
		"id" => "suf_category_sidebar_count",
		"parent" => "category-page",
		"type" => "radio",
		"options" => array("default" => "Get default sidebar layout", "0" => "0 (Zero) - Get \"No Sidebars\" settings",
			"1l" => "1 Left - Get \"1 Left Sidebar\" settings", "1r" => "1 Right - Get \"1 Right Sidebar\" settings",
			"1l1r" => "1 Left, 1 Right - Get \"1 Left, 1 Right Sidebar\" settings",
			"2l" => "2 Left - Get \"2 Left Sidebars\" settings", "2r" => "2 Right - Get \"2 Right Sidebars\" settings", ),
		"std" => "default"),

	array("name" => "Full posts / excerpts / list / tiles / mosaic",
		"id" => "suf_category_excerpt",
		"parent" => "category-page",
		"type" => "radio",
		"options" => array("content" => "Display full content", "excerpt" => "Display excerpt", "list" => "Display list", "tiles" => 'Display tiles', "mosaic" => 'Display mosaic'),
		"std" => "content"),

	array("name" => "Number of Full content posts for Categories",
		"desc" => "In the Excerpt, List and Tile display you can choose to show the first few posts with full content: ",
		"id" => "suf_category_fc_number",
		"parent" => "category-page",
		"type" => "select",
		"options" => array("0" => "0 (Zero)", "1" => "1 (One)", "2" => "2 (Two)", "3" => "3 (Three)", "4" => "4 (Four)",
			"5" => "5 (Five)", "6" => "6 (Six)", "7" => "7 (Seven)", "8" => "8 (Eight)", "9" => "9 (Nine)", "10" => "10 (Ten)"),
		"std" => "0"),

	array("name" => "Tag Views",
		"type" => "sub-section-3",
		"category" => "tag-page",
		"parent" => "layouts"
	),

	array("name" => "Sidebar layout",
		"desc" => "A page displaying posts in a tag will inherit the default number of sidebars. You can change this behavior:",
		"id" => "suf_tag_sidebar_count",
		"parent" => "tag-page",
		"type" => "radio",
		"options" => array("default" => "Get default sidebar layout", "0" => "0 (Zero) - Get \"No Sidebars\" settings",
			"1l" => "1 Left - Get \"1 Left Sidebar\" settings", "1r" => "1 Right - Get \"1 Right Sidebar\" settings",
			"1l1r" => "1 Left, 1 Right - Get \"1 Left, 1 Right Sidebar\" settings",
			"2l" => "2 Left - Get \"2 Left Sidebars\" settings", "2r" => "2 Right - Get \"2 Right Sidebars\" settings", ),
		"std" => "default"),

	array("name" => "Full posts / excerpts / list / tiles / mosaic",
		"id" => "suf_tag_excerpt",
		"parent" => "tag-page",
		"type" => "radio",
		"options" => array("content" => "Display full content", "excerpt" => "Display excerpt", "list" => "Display list", "tiles" => 'Display tiles', "mosaic" => 'Display mosaic'),
		"std" => "content"),

	array("name" => "Number of Full content posts for Tags",
		"desc" => "In the Excerpt, List and Tile display you can choose to show the first few posts with full content: ",
		"id" => "suf_tag_fc_number",
		"parent" => "tag-page",
		"type" => "select",
		"options" => array("0" => "0 (Zero)", "1" => "1 (One)", "2" => "2 (Two)", "3" => "3 (Three)", "4" => "4 (Four)",
			"5" => "5 (Five)", "6" => "6 (Six)", "7" => "7 (Seven)", "8" => "8 (Eight)", "9" => "9 (Nine)", "10" => "10 (Ten)"),
		"std" => "0"),

	array("name" => "Author Views",
		"type" => "sub-section-3",
		"category" => "author-page",
		"parent" => "layouts"
	),

	array("name" => "Sidebar layout",
		"desc" => "A page displaying posts in a tag will inherit the default number of sidebars. You can change this behavior:",
		"id" => "suf_author_sidebar_count",
		"parent" => "author-page",
		"type" => "radio",
		"options" => array("default" => "Get default sidebar layout", "0" => "0 (Zero) - Get \"No Sidebars\" settings",
			"1l" => "1 Left - Get \"1 Left Sidebar\" settings", "1r" => "1 Right - Get \"1 Right Sidebar\" settings",
			"1l1r" => "1 Left, 1 Right - Get \"1 Left, 1 Right Sidebar\" settings",
			"2l" => "2 Left - Get \"2 Left Sidebars\" settings", "2r" => "2 Right - Get \"2 Right Sidebars\" settings", ),
		"std" => "default"),

	array("name" => "Full posts / excerpts / list / tiles / mosaic",
		"id" => "suf_author_excerpt",
		"parent" => "author-page",
		"type" => "radio",
		"options" => array("content" => "Display full content", "excerpt" => "Display excerpt", "list" => "Display list", "tiles" => 'Display tiles', "mosaic" => 'Display mosaic'),
		"std" => "content"),

	array("name" => "Number of Full content posts for Authors",
		"desc" => "In the Excerpt, List and Tile display you can choose to show the first few posts with full content: ",
		"id" => "suf_author_fc_number",
		"parent" => "author-page",
		"type" => "select",
		"options" => array("0" => "0 (Zero)", "1" => "1 (One)", "2" => "2 (Two)", "3" => "3 (Three)", "4" => "4 (Four)",
			"5" => "5 (Five)", "6" => "6 (Six)", "7" => "7 (Seven)", "8" => "8 (Eight)", "9" => "9 (Nine)", "10" => "10 (Ten)"),
		"std" => "0"),

	array("name" => "Date Archive Views",
		"type" => "sub-section-3",
		"category" => "archives-page",
		"parent" => "layouts"
	),

	array("name" => "Sidebar layout",
		"desc" => "A page displaying posts in a date archive will inherit the default number of sidebars. You can change this behavior:",
		"id" => "suf_date_sidebar_count",
		"parent" => "archives-page",
		"type" => "radio",
		"options" => array("default" => "Get default sidebar layout", "0" => "0 (Zero) - Get \"No Sidebars\" settings",
			"1l" => "1 Left - Get \"1 Left Sidebar\" settings", "1r" => "1 Right - Get \"1 Right Sidebar\" settings",
			"1l1r" => "1 Left, 1 Right - Get \"1 Left, 1 Right Sidebar\" settings",
			"2l" => "2 Left - Get \"2 Left Sidebars\" settings", "2r" => "2 Right - Get \"2 Right Sidebars\" settings", ),
		"std" => "default"),

	array("name" => "Full posts / excerpts / list / tiles / mosaic",
		"id" => "suf_archive_excerpt",
		"parent" => "archives-page",
		"type" => "radio",
		"options" => array("content" => "Display full content", "excerpt" => "Display excerpt", "list" => "Display list", "tiles" => 'Display tiles', "mosaic" => 'Display mosaic'),
		"std" => "content"),

	array("name" => "Number of Full content posts for date-based archives",
		"desc" => "In the Excerpt, List and Tile display you can choose to show the first few posts with full content: ",
		"id" => "suf_archive_fc_number",
		"parent" => "archives-page",
		"type" => "select",
		"options" => array("0" => "0 (Zero)", "1" => "1 (One)", "2" => "2 (Two)", "3" => "3 (Three)", "4" => "4 (Four)",
			"5" => "5 (Five)", "6" => "6 (Six)", "7" => "7 (Seven)", "8" => "8 (Eight)", "9" => "9 (Nine)", "10" => "10 (Ten)"),
		"std" => "0"),

	array("name" => "Search Result Views",
		"type" => "sub-section-3",
		"category" => "search-page",
		"parent" => "layouts"
	),

	array("name" => "Sidebar layout",
		"desc" => "A page displaying posts in a search results will inherit the default number of sidebars. You can change this behavior:",
		"id" => "suf_search_sidebar_count",
		"parent" => "search-page",
		"type" => "radio",
		"options" => array("default" => "Get default sidebar layout", "0" => "0 (Zero) - Get \"No Sidebars\" settings",
			"1l" => "1 Left - Get \"1 Left Sidebar\" settings", "1r" => "1 Right - Get \"1 Right Sidebar\" settings",
			"1l1r" => "1 Left, 1 Right - Get \"1 Left, 1 Right Sidebar\" settings",
			"2l" => "2 Left - Get \"2 Left Sidebars\" settings", "2r" => "2 Right - Get \"2 Right Sidebars\" settings", ),
		"std" => "default"),

	array("name" => "Full posts / excerpts / list / tiles / mosaic",
		"id" => "suf_search_excerpt",
		"parent" => "search-page",
		"type" => "radio",
		"options" => array("content" => "Display full content", "excerpt" => "Display excerpt", "list" => "Display list", "tiles" => 'Display tiles', "mosaic" => 'Display mosaic'),
		"std" => "content"),

	array("name" => "Number of Full content posts for Search Results",
		"desc" => "In the Excerpt, List and Tile display you can choose to show the first few posts with full content: ",
		"id" => "suf_search_fc_number",
		"parent" => "search-page",
		"type" => "select",
		"options" => array("0" => "0 (Zero)", "1" => "1 (One)", "2" => "2 (Two)", "3" => "3 (Three)", "4" => "4 (Four)",
			"5" => "5 (Five)", "6" => "6 (Six)", "7" => "7 (Seven)", "8" => "8 (Eight)", "9" => "9 (Nine)", "10" => "10 (Ten)"),
		"std" => "0"),

	array("name" => "Layout: Excerpt / List / Tile / Mosaic / Full",
		"type" => "sub-section-3",
		"category" => "excerpt-settings",
		"parent" => "layouts"
	),

	array("name" => "Full content posts on first page / all pages (for selections above)",
		"desc" => "Show full content posts only on the first page of a category/tag/time archive etc. This Setting will also apply to Templates &rarr; Page of Posts: ",
		"id" => "suf_fc_view_first_only",
		"parent" => "excerpt-settings",
		"type" => "radio",
		"options" => array("first" => "First page only", "all" => "All pages (second, third etc)"),
		"std" => "first"),

	array("name" => "General Excerpt settings",
		"desc" => "Control general settings for excerpts",
		"category" => "excerpt-gen",
		"parent" => "excerpt-settings",
		"type" => "sub-section-4",),

	array("name" => "Number of words in auto-generated excerpts",
		"desc" => "By default auto-generated excerpts in WordPress are 55 words long. You can set this length to anything you like:",
		"id" => "suf_excerpt_custom_length",
		"parent" => "excerpt-settings",
		"grouping" => "excerpt-gen",
		"type" => "text",
		"hint" => "Enter the number of words here.",
		"std" => "55"),

	array("name" => "\"Read more\" style",
		"desc" => "Pick how you want your \"Read more\" for excerpts to appear: ",
		"id" => "suf_excerpt_read_more_style",
		"parent" => "excerpt-settings",
		"grouping" => "excerpt-gen",
		"type" => "select",
		"options" => array("replace" => "Replace the \"[...]\" text at the end of an automatic excerpt (nothing appears for manual excerpts or short posts",
			"append" => "Append a link to every excerpt (the \"[...]\" text will show for automatic excerpts)"),
		"std" => "replace"),

	array("name" => "\"Read more\" text in excerpts",
		"desc" => "By default auto-generated excerpts in WordPress end with \"[...]\". If you have chosen to \"replace\" above, the \"[...]\" is replaced.
			Otherwise this is appended to the excerpt:",
		"id" => "suf_excerpt_custom_more_text",
		"parent" => "excerpt-settings",
		"grouping" => "excerpt-gen",
		"type" => "text",
		"std" => "[...]"),

	array("name" => "Thumbnail settings",
		"desc" => "Control settings for thumbnails",
		"category" => "excerpt-thumb",
		"parent" => "excerpt-settings",
		"type" => "sub-section-4",),

	array("name" => "Show thumbnails for excerpts",
		"desc" => "If you are retrieving an excerpt, you can display a thumbnail for it.
			So if you have a Post Thumbnail set in your Edit Page or Edit Post screen (right side), this takes precedence.
			Otherwise the thumbnail is picked up from the URL provided in the \"Thumbnail\" setting of a post or a page:",
		"id" => "suf_show_excerpt_thumbnail",
		"parent" => "excerpt-settings",
		"grouping" => "excerpt-thumb",
		"type" => "radio",
		"options" => array("show" => "Display Thumbnail, if available", "hide" => "Hide Thumbnail"),
		"std" => "show"),

	array("name" => "Show featured images for full content",
		"desc" => "Note that to use this feature your thumbnail must be defined in the \"Featured Image\" section of your Edit Page or Edit Post screen:",
		"id" => "suf_show_content_thumbnail",
		"parent" => "excerpt-settings",
		"grouping" => "excerpt-thumb",
		"type" => "radio",
		"options" => array(
			"show" => "Display featured image, if available",
			"hide" => "Don't show any image"
		),
		"std" => "show"),

	array("name" => "Image preference order",
		"desc" => "You can change the order of preference for picking up images. If an image is not found for your first preference, the next one is looked for: ",
		"id" => "suf_excerpt_img_pref",
		"parent" => "excerpt-settings",
		"grouping" => "excerpt-thumb",
		"type" => "sortable-list",
		"std" => suffusion_entity_prepositions('thumb-excerpt')),

	array("name" => "Proportional resizing",
		"desc" => "If you are resizing an image 400x200 px to 250x150, the resizing is disproportionate. How do you want to handle the resize in such a scenario?",
		"id" => "suf_excerpt_tt_zc",
		"parent" => "excerpt-settings",
		"grouping" => "excerpt-thumb",
		"type" => "radio",
		"options" => array("0" => "Preserve original proportions (final size might be different from desired size)",
			"1" => "Transform to desired proportions (image might get cropped)"),
		"std" => "1"),

	array("name" => "Set compression quality",
		"desc" => "Adjust this if you want to change the quality of your compressed image. The default is 75:",
		"id" => "suf_excerpt_tt_quality",
		"parent" => "excerpt-settings",
		"grouping" => "excerpt-thumb",
		"type" => "slider",
		"options" => array("range" => "min", "min" => 25, "max" => 100, "step" => 1, "size" => "400px", "unit" => ""),
		"std" => 75),

	array("name" => "Thumbnail alignment in excerpts",
		"desc" => "You can set the thumbnail (if present) to appear either on the left or on the right of the excerpt:",
		"id" => "suf_excerpt_thumbnail_alignment",
		"parent" => "excerpt-settings",
		"grouping" => "excerpt-thumb",
		"type" => "radio",
		"options" => array("left" => "Show thumbnail on the left of the excerpt", "right" => "Show thumbnail on the right of the excerpt"),
		"std" => "left"),

	array("name" => "Thumbnail size in excerpts",
		"desc" => "You can set the size of the thumbnail (if present). This is the size of the thumbnail in the excerpt:",
		"id" => "suf_excerpt_thumbnail_size",
		"parent" => "excerpt-settings",
		"grouping" => "excerpt-thumb",
		"type" => "radio",
		"options" => array("thumbnail" => "Thumbnail size, as defined in Settings -&gt; Media",
			"medium" => "Medium size, as defined in Settings -&gt; Media",
			"large" => "Large size, as defined in Settings -&gt; Media",
			"full" => "Full size of the image",
			"custom" => "Custom size defined below"),
		"std" => "thumbnail"),

	array("name" => "Custom width of thumbnail",
		"desc" => "If you have chosen to define a custom size above, please enter the width in pixels:",
		"id" => "suf_excerpt_thumbnail_custom_width",
		"parent" => "excerpt-settings",
		"grouping" => "excerpt-thumb",
		"type" => "text",
		"hint" => "Enter the number of pixels here (don't enter 'px'). Non-integers will be ignored.",
		"std" => "200"),

	array("name" => "Custom height of thumbnail",
		"desc" => "If you have chosen to define a custom size above, please enter the height in pixels:",
		"id" => "suf_excerpt_thumbnail_custom_height",
		"parent" => "excerpt-settings",
		"grouping" => "excerpt-thumb",
		"type" => "text",
		"hint" => "Enter the number of pixels here (don't enter 'px'). Non-integers will be ignored.",
		"std" => "200"),

	array("name" => "List layout",
		"desc" => "Control settings for \"Display List\" option ",
		"category" => "layout-list",
		"parent" => "excerpt-settings",
		"type" => "sub-section-4",),

	array("name" => "Number of posts in \"Display List\" option",
		"desc" => "If you have selected \"Display List\" for any of the views above, you can control the number of posts to show per page:",
		"id" => "suf_excerpt_list_count",
		"parent" => "excerpt-settings",
		"grouping" => "layout-list",
		"type" => "radio",
		"options" => array("all" => "Show all results",
			"posts-per-page" => "Show as many posts as allowed in the 'Posts Per Page' setting in Settings -&gt; Reading",),
		"std" => "all"),

	array("name" => "List style in \"Display List\" option",
		"desc" => "If you have selected \"Display List\" for any of the views above, you can choose to show ordered or unordered lists:",
		"id" => "suf_excerpt_list_style",
		"parent" => "excerpt-settings",
		"grouping" => "layout-list",
		"type" => "radio",
		"options" => array("ul" => "Unordered List", "ol" => "Ordered List",),
		"std" => "ul"),

	array("name" => "Tile layout",
		"desc" => "Control settings for \"Display Tiles\" option ",
		"category" => "layout-tiles",
		"parent" => "excerpt-settings",
		"type" => "sub-section-4",),

	array("name" => "Number of excerpts per row in \"Display Tiles\" option",
		"desc" => "If you have selected \"Display Tiles\" option for any of the views above, you can control the number of excerpts (tiles) to show per row:",
		"id" => "suf_tile_excerpts_per_row",
		"parent" => "excerpt-settings",
		"grouping" => "layout-tiles",
		"type" => "select",
		"options" => array("1" => "1 (One)", "2" => "2 (Two)", "3" => "3 (Three)", "4" => "4 (Four)", "5" => "5 (Five)", "6" => "6 (Six)", "7" => "7 (Seven)",
			"8" => "8 (Eight)", "9" => "9 (Nine)", "10" => "10 (Ten)"),
		"std" => "3"),

	array("name" => "Thumbnail container for excerpts",
		"desc" => "You can show thumbnails for excerpts in the tiles display: ",
		"id" => "suf_tile_images_enabled",
		"parent" => "excerpt-settings",
		"grouping" => "layout-tiles",
		"type" => "radio",
		"options" => array("show" => "Always show Thumbnail container", "hide" => "Always hide Thumbnail container",
			"hide-empty" => "Hide Thumbnail container if there is no thumbnail"),
		"std" => "show"),

	array("name" => "Thumbnail container height for excerpts",
		"desc" => "For the purposes of visual consistency you can set the height of the box in which the thumbnail will be placed. Your thumbnail will be \"cropped\" to this height: ",
		"id" => "suf_tile_image_box_height",
		"parent" => "excerpt-settings",
		"grouping" => "layout-tiles",
		"type" => "text",
		"hint" => "Enter the number of pixels here (don't enter 'px'). Non-integers will be ignored.",
		"std" => "100"),

	array("name" => "Thumbnail image and size settings",
		"desc" => "By default this uses the image preference order, size and other settings defined under <i>Templates &rarr; Magazine</i>: ",
		"id" => "suf_tile_image_settings",
		"parent" => "excerpt-settings",
		"grouping" => "layout-tiles",
		"type" => "radio",
		"options" => array("inherit" => "Use settings under <i>Templates &rarr; Magazine</i>",
			"native" => "Use settings below"),
		"std" => "inherit"),

	array("name" => "Image preference order",
		"desc" => "You can change the order of preference for picking up images. If an image is not found for your first preference, the next one is looked for: ",
		"id" => "suf_tile_img_pref",
		"parent" => "excerpt-settings",
		"grouping" => "layout-tiles",
		"type" => "sortable-list",
		"std" => suffusion_entity_prepositions('thumb-tiles')),

	array("name" => "Tile thumbnail image scaling",
		"desc" => "You can set a custom size for your excerpt thumbnail images, or let the size be the same as that of the regular excerpt images: ",
		"id" => "suf_tile_image_size",
		"parent" => "excerpt-settings",
		"grouping" => "layout-tiles",
		"type" => "radio",
		"options" => array("excerpt" => "Same size as excerpt images", "custom" => "Custom size (defined below)"),
		"std" => "excerpt"),

	array("name" => "Custom height of thumbnail image in tiles",
		"desc" => "If you have picked a custom size for the excerpt thumbnail images above, you can set the height here: ",
		"id" => "suf_tile_image_custom_height",
		"parent" => "excerpt-settings",
		"grouping" => "layout-tiles",
		"type" => "text",
		"hint" => "Enter the number of pixels here (don't enter 'px'). Non-integers will be ignored.",
		"std" => "200"),

	array("name" => "Custom width of thumbnail image in tiles",
		"desc" => "If you have picked a custom size for the excerpt thumbnail images above, you can set the width here: ",
		"id" => "suf_tile_image_custom_width",
		"parent" => "excerpt-settings",
		"grouping" => "layout-tiles",
		"type" => "text",
		"hint" => "Enter the number of pixels here (don't enter 'px'). Non-integers will be ignored.",
		"std" => "200"),

	array("name" => "Proportional resizing",
		"desc" => "If you are resizing an image 400x200 px to 250x150, the resizing is disproportionate. How do you want to handle the resize in such a scenario?",
		"id" => "suf_tile_zc",
		"parent" => "excerpt-settings",
		"grouping" => "layout-tiles",
		"type" => "radio",
		"options" => array("default" => "Inherit setting from thumbnail above",
			"0" => "Preserve original proportions (final size might be different from desired size)",
			"1" => "Transform to desired proportions (image might get cropped)"),
		"std" => "default"),

	array("name" => "Display Tiles - Alignment of post title in Excerpts",
		"desc" => "You can set the alignment for the post title in the excerpts: ",
		"id" => "suf_tile_title_alignment",
		"parent" => "excerpt-settings",
		"grouping" => "layout-tiles",
		"type" => "radio",
		"options" => array("theme" => "Theme Default", "left" => "Left", "center" => "Center", "right" => "Right"),
		"std" => "theme"),

	array("name" => "Tile Layout Bylines",
		"desc" => "Control how bylines are displayed for excerpts",
		"category" => "tile-layout-bylines",
		"parent" => "excerpt-settings",
		"type" => "sub-section-4",),

	array("name" => "Show bylines for tiled excerpts",
		"desc" => "You can show bylines for magazine excerpts: ",
		"id" => "suf_tile_layout_bylines_enabled",
		"grouping" => "tile-layout-bylines",
		"parent" => "excerpt-settings",
		"type" => "radio",
		"options" => array("show" => "Show", "hide" => "Hide"),
		"std" => "show"),

	array("name" => "Show post date",
		"id" => "suf_tile_layout_bylines_post_date",
		"grouping" => "tile-layout-bylines",
		"parent" => "excerpt-settings",
		"grouping" => "layout-tiles",
		"type" => "radio",
		"options" => array("show" => "Show", "hide" => "Hide"),
		"std" => "show"),

	array("name" => "Show \"Posted by\"",
		"id" => "suf_tile_layout_bylines_posted_by",
		"grouping" => "tile-layout-bylines",
		"parent" => "excerpt-settings",
		"type" => "radio",
		"options" => array("show" => "Show", "hide" => "Hide"),
		"std" => "show"),

	array("name" => "Show \"Categories\"",
		"id" => "suf_tile_layout_bylines_categories",
		"grouping" => "tile-layout-bylines",
		"parent" => "excerpt-settings",
		"type" => "radio",
		"options" => array("show" => "Show", "hide" => "Hide"),
		"std" => "show"),

	array("name" => "Show \"Tags\"",
		"id" => "suf_tile_layout_bylines_tags",
		"grouping" => "tile-layout-bylines",
		"parent" => "excerpt-settings",
		"type" => "radio",
		"options" => array("show" => "Show", "hide" => "Hide"),
		"std" => "show"),

	array("name" => "Show \"Comments\"",
		"id" => "suf_tile_layout_bylines_comments",
		"grouping" => "tile-layout-bylines",
		"parent" => "excerpt-settings",
		"type" => "radio",
		"options" => array("show" => "Show", "hide" => "Hide"),
		"std" => "show"),

	array("name" => "Show \"Permalinks\"",
		"id" => "suf_tile_layout_bylines_permalinks",
		"grouping" => "tile-layout-bylines",
		"parent" => "excerpt-settings",
		"type" => "radio",
		"options" => array("show" => "Show", "hide" => "Hide"),
		"std" => "show"),

	array("name" => "Mosaic layout",
		"desc" => "Control settings for \"Display Mosaic\" option ",
		"category" => "layout-mosaic",
		"parent" => "excerpt-settings",
		"type" => "sub-section-4",),

	array("name" => "Width of mosaic thumbnail",
		"desc" => "If you have selected \"Display Mosaic\" option for any of the views above, set the width of each mosaic thumbnail:",
		"id" => "suf_mosaic_thumbnail_width",
		"parent" => "excerpt-settings",
		"grouping" => "layout-mosaic",
		"type" => "select",
		"options" => array("64" => "64px", "96" => "96px", "128" => "128px", "192" => "192px", "256" => "256px", ),
		"std" => "96"),

	array("name" => "Height of mosaic thumbnail",
		"desc" => "If you have selected \"Display Mosaic\" option for any of the views above, set the width of each mosaic thumbnail:",
		"id" => "suf_mosaic_thumbnail_height",
		"parent" => "excerpt-settings",
		"grouping" => "layout-mosaic",
		"type" => "select",
		"options" => array("64" => "64px", "96" => "96px", "128" => "128px", "192" => "192px", "256" => "256px", ),
		"std" => "96"),

	array("name" => "Proportional resizing",
		"desc" => "If you are resizing an image 400x300 px to 128x128, the resizing is disproportionate. How do you want to handle the resize in such a scenario?",
		"id" => "suf_mosaic_zc",
		"parent" => "excerpt-settings",
		"grouping" => "layout-mosaic",
		"type" => "radio",
		"options" => array("0" => "Preserve original proportions (final size might be different from desired size)",
			"1" => "Transform to desired proportions (image might get cropped)"),
		"std" => "1"),

	array("name" => "Constrain the number of thumbnails per row",
		"desc" => "You can set the number of thumbnails per row by defining the padding around the thumbnails, or by fixing the number of thumbnails per row",
		"id" => "suf_mosaic_constrain_row",
		"parent" => "excerpt-settings",
		"grouping" => "layout-mosaic",
		"type" => "radio",
		"options" => array("padding" => "Fix the padding around the thumbnails",
			"count" => "Fix the number of thumbnails per row"),
		"std" => "padding"),

	array("name" => "Constrain by padding",
		"desc" => " If you have constrained by padding above, enter the number of pixels here to pad the thumbs by",
		"id" => "suf_mosaic_constrain_by_padding",
		"parent" => "excerpt-settings",
		"grouping" => "layout-mosaic",
		"type" => "text",
		"hint" => "Enter the number of pixels here (don't enter 'px'). Non-integers will be ignored.",
		"std" => "50"),

	array("name" => "Constrain by number of thumbnails",
		"desc" => " If you have constrained by number of thumbnails per row above, enter the number of thumbnails",
		"id" => "suf_mosaic_constrain_by_count",
		"parent" => "excerpt-settings",
		"grouping" => "layout-mosaic",
		"type" => "slider",
		"options" => array("range" => "min", "min" => 1, "max" => 15, "step" => 1, "size" => "400px", "unit" => ""),
		"std" => 5),

	array("name" => "Allow thumbnail zooming",
		"desc" => "You can open the original image for a mosaic thumbnail without going to the post",
		"id" => "suf_mosaic_zoom",
		"parent" => "excerpt-settings",
		"grouping" => "layout-mosaic",
		"type" => "radio",
		"options" => array("zoom" => "Allow zooming",
			"no-zoom" => "Disallow zooming"),
		"std" => "zoom"),

	array("name" => "Zooming library if zooming is allowed",
		"desc" => "Which JS library should be used?",
		"id" => "suf_mosaic_zoom_library",
		"parent" => "excerpt-settings",
		"grouping" => "layout-mosaic",
		"type" => "radio",
		"options" => array("fancybox" => "Fancybox",
			"colorbox" => "Colorbox",
			"none" => "None: default to a plugin's script and save bandwidth. You must have a plugin that bundles Fancybox or Colorbox to select this."
		),
		"std" => "fancybox"),

	array("name" => "Show post title below thumbnail?",
		"id" => "suf_mosaic_show_title",
		"parent" => "excerpt-settings",
		"grouping" => "layout-mosaic",
		"type" => "radio",
		"options" => array("show" => "Show",
			"hide" => "Hide"),
		"std" => "hide"),

);
