<?php

/*

Plugin Name: Suffusion to All In One SEO Migration

Plugin URI: http://drafie-design.nl/

Description: Imports Suffusion SEO data into All in One SEO Pack

Version: 0.1

Author: Ciprian Dracea (Drake)

Author URI: http://drafie-design.nl/

*/

add_action('admin_menu', 'suf_aioseo_m');
function suf_aioseo_m() {
  add_options_page('Suffusion to AIO SEO Migration', 'Suffusion -> AIOSEOP Migration', 'manage_options', 'suf_aioseopm', 'suf_aioseop_mgr_options');
}


function suf_aioseop_mgr_options() {
  if (!current_user_can('manage_options'))  {
    wp_die( __('You do not have sufficient permissions to access this page.') );
  }
?>  


<div class="wrap">

<h2>Suffusion to AIO SEO Migration</h2>

<div>

<?php

	if(!empty( $_POST ) && $_POST['action'] == 'import_suffusion' && $nonce = $_POST['nonce-suf-aioseop-migrate']){

		if (!wp_verify_nonce($nonce, 'suf-aioseop-migrate-nonce')) die ( 'Security Check - If you receive this in error, log out and back in to WordPress');

		else {
			suf_aioseop_mgr_import();
		}
	}
?>
</div>

<p>This plugin works only with All in One SEO Pack installed. Make sure to set the plugin properly. <b>If you use Suffusion SEO Keywords, then go to All in One SEO -> General Settings -> Keyword Settings and set them to "Enabled"</b> (otherwise will lose the keywords after migration).</p>
<p>Copy manually the informations from Suffusion Options -> Backend -> SEO/Meta Settings to corresponding fields from All In One SEO -> General Settings. The plugin is intended to migrate only the SEO META DATA for all individual posts.</p>
<p style="color:red;">WARNING! Before using this plugin please make a backup of your database. After hitting "Migrate" button, all AIO SEO data for posts will be replaced with Suffusion SEO data and SUffusion SEO data will be removed from the database.</p>

<div style="float:left;background-color:white;padding: 10px 10px 10px 10px;margin-right:15px;border: 1px solid #ddd;">
	<h3>All in One SEO Pack Data</h3>
	<?php 
	global $wpdb;

	$aioseoptitlecount = $wpdb->get_var("SELECT COUNT(*) FROM $wpdb->postmeta WHERE meta_key='_aioseop_title';");

	$aioseopdesccount = $wpdb->get_var("SELECT COUNT(*) FROM $wpdb->postmeta WHERE meta_key='_aioseop_description';");

	$aioseopkeywordscount = $wpdb->get_var("SELECT COUNT(*) FROM $wpdb->postmeta WHERE meta_key='_aioseop_keywords';");

	echo "<br />Posts with Titles: " . $aioseoptitlecount;

	echo "<br />Posts with Descriptions: " . $aioseopdesccount;

	echo "<br />Posts with Keywords: " . $aioseopkeywordscount;

	?>

</div>



<div style="float:left;background-color:white;padding: 10px 10px 10px 10px;margin-right:15px;border: 1px solid #ddd;">

	<h3>Suffusion Data</h3>

	<?php 

	global $wpdb;
if (is_home()) {
	$suf_desccount = $wpdb->get_var("SELECT COUNT(*) FROM $wpdb->postmeta WHERE meta_key='suf_seo_meta_description';");
}
	else {
	$suf_desccount = $wpdb->get_var("SELECT COUNT(*) FROM $wpdb->postmeta WHERE meta_key='suf_meta_description';");
}

if (is_home() || is_category() || is_tag() || is_tax() || is_author()) {

	$suf_keywordscount = $wpdb->get_var("SELECT COUNT(*) FROM $wpdb->postmeta WHERE meta_key='suf_seo_meta_keywords';");

}
	else {
$suf_keywordscount = $wpdb->get_var("SELECT COUNT(*) FROM $wpdb->postmeta WHERE meta_key='suf_meta_keywords';");
}
	echo "<br />Suffusion use WordPress titles";

	echo "<br />Posts with Descriptions: " . $suf_desccount;

	echo "<br />Posts with Keywords: " . $suf_keywordscount;

	?>

</div>

<div style="clear:both;"></div>

<form method="post" action="" name="migrate-suf-aioseop">

<input type='hidden' name='nonce-suf-aioseop-migrate' value="<?php echo wp_create_nonce('suf-aioseop-migrate-nonce'); ?>" />

<input type="hidden" name="action" value="import_suffusion" />

<p class="submit">

<input type="submit" class="button-primary" value="<?php _e('Migrate Suffusion SEO Data') ?>" />

</p>


</form>

</div>


<?php

}

function suf_aioseop_mgr_import(){

	global $wpdb;
         
//	$wpdb->query( "UPDATE $wpdb->postmeta SET meta_key='_aioseop_title' WHERE meta_key='title'");

	$wpdb->query( "UPDATE $wpdb->postmeta SET meta_key='_aioseop_description' WHERE meta_key='suf_meta_description'");

	$wpdb->query( "UPDATE $wpdb->postmeta SET meta_key='_aioseop_keywords' WHERE meta_key='suf_meta_keywords'");

	echo "<br />SEO DATA UPDATED<br />";

}

?>