/**
 * Browser Shots TinyMCE Integration
 */

(function() {
	var properties = [];

	properties.push(
		{
			'type': 'textbox',
			'name': 'url',
			'label': 'Image Url',
			'value': 'http://prothemedesign.com/',
			'tooltip': 'URL of the site for which you want the webshot',
			'size': 40
		},
		{
			'type': 'textbox',
			'name': 'width',
			'label': 'Image Width',
			'tooltip': 'Custom width of the image, input only the value, no \'px\' - default 600px',
			'value': '600',
			'size': 10
		},
		{
			'type': 'textbox',
			'name': 'height',
			'label': 'Image Height',
			'tooltip': 'Custom height of the image, input only the value, no \'px\' - default 450px',
			'value': '450',
			'size': 10
		},
		{
			'type': 'textbox',
			'name': 'alt',
			'label': 'ALT text of image',
			'tooltip': 'ALT text for generated image. If empty, ALT attribute will be empty but present, for proper validation',
			'value': '',
			'size': 40
		},
		{
			'type': 'textbox',
			'name': 'link_url',
			'label': 'Link Url',
			'tooltip': 'Allows you to change the url that the screenshot links to',
			'value': '',
			'size': 40
		},
		{
			'type': 'checkbox',
			'checked': true,
			'text': 'Open in new window/tab? Un-check the box if you want the link to open in the same window.',
			'name': 'target'
		},
		{
			'type': 'textbox',
			'name': 'caption',
			'label': 'Caption',
			'tooltip': 'Here can add a caption if you want one. If you have selected a text in editor before pressing \'Browser Shot\' button, that text will be your caption and this field is useless.',
			'value': '',
			'size': 40
		}


	);

	var shortcode_name = 'browser-shot';

	tinymce.create( 'tinymce.plugins.browsershots', {
		init: function(editor, url) {
			editor.addButton('browsershots', {
				title: 'Browser Shots',
				image: url.replace('/js', '/images') + '/browsershots-icon.png',
				onclick: function() {
					editor.windowManager.open({
                        title: 'Browser Shots',
                        body: properties,
                        onsubmit: function (e) {

							/* Dialog prompt's */
							var width = e.data.width;
							var height = e.data.height;
							var alt = e.data.alt;
							var website = e.data.url;
							var link_url = e.data.link_url;
							var target = e.data.target;
							var caption = e.data.caption;

							/* Build shortcode tag */
							if ( website != null && website != '' ) {
								var shortcode = '[' + shortcode_name + ' url="' + website + '"';
								if ( width != null && width != '' ) {
									shortcode += ' width="' + width + '"';
								}
								if ( height != null && height != '' ) {
									shortcode += ' height="' + height + '"';
								}
								shortcode += ' alt="' + alt + '"';
								if ( link_url != null && link_url != '' ) {
									shortcode += ' link="' + link_url + '"';
								}
								if (target == true) {
									shortcode += ' target="_blank"';
								}
								shortcode += ']';

								var selection = editor.selection.getContent();
								if ( selection.length ) {
									var code = shortcode + selection + '[/' + shortcode_name + ']';
									editor.selection.setContent( code );
								} else if ( caption != null && caption != '' ) {
									var code = shortcode + caption + '[/' + shortcode_name + ']';
									editor.insertContent( code );
								} else {
									editor.insertContent( shortcode );
								}
							}

                        }
                    });

				}
			});
		},
		createControl: function(n, cm) {
			return null;
		},
		getInfo: function() {
			return {
				longname: 'Browser Shots',
				author: 'Ben Gillbanks',
				authorurl: 'http://prothemedesign.com',
				infourl: 'http://wordpress.org/extend/plugins/browser-shots/',
				version: '1.3'
			};
		}
	});

	tinymce.PluginManager.add( 'browsershots', tinymce.plugins.browsershots );

})();