/**
 * TinyMCE Integration
 */
 
(function() {
	tinymce.create('tinymce.plugins.browsershots', {
		init: function(ed, url) {
			ed.addButton('browsershots', {
				title: 'Browser Shots',
				image: url.replace('/js', '/images') + '/browsershots-icon.png',
				onclick: function() {
				/* Changed on 15.01.2015 by Ciprian Dracea (Drake) - http://drafie-design.nl */
					/* Dialog prompt's */
					var width = prompt("Screenshot width:", "600");
					var height = prompt("Screenshot height:", "");
					var website = prompt("What's the URL of the website?", "http://www.kevinleary.net");
					var bm_alt = prompt("Image alt text","");
					var bm_link = prompt("URL where the image links. Left blank it will point to the website where the screenshot is being taken","");
					var bm_target = confirm("Open in new browser window/tab?");
					var bm_caption = prompt("Insert a caption if you want one","");
					
					/* Build shortcode tag */
					if ( website != null && website != '' ) {
						var shortcode = '[browser-shot url="' + website + '"';
						if ( width != null && width != '' ) {
							shortcode += ' width="' + width + '"';
						}
						if ( height != null && height != '' ) {
							shortcode += ' height="' + height + '"';
						}
						if (bm_link != null && bm_link !='') {
							shortcode += ' link="' + bm_link + '"';
						}
						if (bm_target == true) {
							shortcode += ' target="_blank"';
						}
						shortcode += ' alt="' + bm_alt + '"';
						shortcode += ']' + bm_caption + '[/browser-shot]';
						ed.execCommand( 'mceInsertContent', false, shortcode );
					}
				}
			});
		},
		createControl: function(n, cm) {
			return null;
		},
		getInfo: function() {
			return {
				longname: "Browser Shots",
				author: 'Kevin Leary',
				authorurl: 'http://www.kevinleary.net',
				infourl: 'http://wordpress.org/extend/plugins/browser-shots/',
				version: "1.2"
			};
		}
	});
	tinymce.PluginManager.add('browsershots', tinymce.plugins.browsershots);
})();